(deftemplate sensor
	(slot name 
		(type SYMBOL))
	(slot suspect 
		(type SYMBOL) 
		(allowed-symbols yes no)
		(default no))
)

(deftemplate component
	(slot name
		(type SYMBOL))
	(slot suspect 
		(type SYMBOL) 
		(allowed-symbols yes no)
		(default no))
	(multislot connects_with
		(type SYMBOL) )
)

(deftemplate allsensors
	(multislot names
		(type SYMBOL))
)

(deffacts sensors
	(sensor (name m1))
	(sensor (name m2))
	(sensor (name m3))
	(sensor (name m4))
	(sensor (name m5))
	(allsensors)
)

(deffacts components
	(component (name s11) (connects_with s21 s22))
	(component (name s12) (connects_with s22))
	(component (name s13) (connects_with s23 m5))
	(component (name s14) (connects_with m5))
	(component (name s21) (connects_with m1 m2))
	(component (name s22) (connects_with m2 m3))
	(component (name s23) (connects_with m3 m4))
)


(defrule collect-sensors
	(initial-fact)
	?x <- (allsensors (names $?ss))
	(sensor (name ?s))
	(test (not (member$ ?s $?ss)))
  =>
	(modify ?x (names (create$ ?s $?ss)))
)

(defrule init-question
	?x <- (initial-fact)
	(allsensors (names $?ss))
  =>
	(retract ?x)
	(set-strategy mea)
	(printout t "Which sensors show discrepancy? " $?ss " ")
	(bind $?answer (explode$ (readline)))
	(assert (discrepancy $?answer))
	(assert (goal make-suspects))
)

(defrule init-suspects
	(goal make-suspects)
	(discrepancy $? ?s $?)
	?x <- (sensor (name ?s) (suspect no))
  =>
	(modify ?x (suspect yes))
)

(defrule propagate-suspect1
	(goal make-suspects)
	(sensor (name ?s) (suspect yes))
	?x <- (component (connects_with $? ?s $?) (suspect no))
  =>
	(modify ?x (suspect yes))
)

(defrule propagate-suspect2
	(goal make-suspects)
	(component (name ?c) (suspect yes))
	?x <- (component (connects_with $? ?c $?) (suspect no))
  =>
	(modify ?x (suspect yes))
)

(defrule make-suspects-continue
	?x <- (goal make-suspects)
  =>
	(retract ?x)
	(assert (goal exonerate-components))
)

(defrule exonerate-components1
	(goal exonerate-components)
	?x <- (component (suspect yes) (connects_with $? ?c $?))
	(component (name ?c) (suspect no))
  =>
	(modify ?x (suspect no))
)

(defrule exonerate-components2
	(goal exonerate-components)
	?x <- (component (suspect yes) (connects_with $? ?s $?))
	(sensor (name ?s) (suspect no))
  =>
	(modify ?x (suspect no))
)

(defrule exonerate-components3
	(goal exonerate-components)
	?x <- (component (name ?c) (suspect yes) (connects_with ?s))
	(sensor (name ?s) (suspect yes))
	(sensor (name ~?s) (suspect yes))
  =>
	(modify ?x (suspect no))
)

(defrule exonerate-components-continue
	?x <- (goal exonerate-components)
  =>
	(retract ?x)
	(assert (goal exonerate-sensors))
)

(defrule exonerate-sensors
	(goal exonerate-sensors)
	?x <- (sensor (name ?s) (suspect yes))
	(component (name ?c) (suspect yes) (connects_with $? ?s $?))
  =>
	(modify ?x (suspect no))
)

(defrule exonerate-sensors-continue
	?x <- (goal exonerate-sensors)
  =>
	(retract ?x)
	(assert (goal announce-result))
)

(defrule announce-result1
	(goal announce-result)
	(component (name ?c) (suspect yes))
	(not (component (name ~?c) (suspect yes) (connects_with $? ?c $?)))
  =>
	(printout t "Component " ?c " malfunctions!" crlf)
)

(defrule announce-result2
	(goal announce-result)
	(sensor (name ?s) (suspect yes))
  =>
	(printout t "Sensor " ?s " malfunctions!" crlf)
)
